/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StandardDrawerGroup
extends BlockEntityDataShim
implements IDrawerGroup {
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemRepository>(){});
    private final DrawerData[] slots;
    private final int[] order;
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new DrawerItemHandler(this));
    private final LazyOptional<IItemRepository> itemRepository = LazyOptional.of(() -> new DrawerItemRepository(this));

    public StandardDrawerGroup(int slotCount) {
        this.slots = new DrawerData[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = this.createDrawer(i);
        }
        this.order = new int[slotCount];
        this.syncSlots();
    }

    public void setCapabilityProvider(ICapabilityProvider capProvider) {
        for (DrawerData slot : this.slots) {
            slot.setCapabilityProvider(capProvider);
        }
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED;
        }
        return this.slots[slot];
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    @Override
    public void read(CompoundTag tag) {
        if (!tag.m_128441_("Drawers")) {
            return;
        }
        ListTag itemList = tag.m_128437_("Drawers", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            if (i >= this.slots.length) continue;
            this.slots[i].deserializeNBT(itemList.m_128728_(i));
        }
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        if (this.slots == null) {
            return tag;
        }
        ListTag itemList = new ListTag();
        for (DrawerData slot : this.slots) {
            itemList.add((Object)slot.serializeNBT());
        }
        tag.m_128365_("Drawers", (Tag)itemList);
        return tag;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return this.itemRepository.cast();
        }
        return LazyOptional.empty();
    }

    @NotNull
    protected abstract DrawerData createDrawer(int var1);

    public void syncAttributes() {
        for (DrawerData drawer : this.slots) {
            drawer.syncAttributes();
        }
    }

    public void syncSlots() {
        IDrawer drawer;
        int i;
        int index = 0;
        for (i = 0; i < this.slots.length; ++i) {
            drawer = this.getDrawer(i);
            if (drawer.isEmpty()) continue;
            this.order[index++] = i;
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (!drawer.isEnabled() || !drawer.isEmpty()) continue;
                this.order[index++] = i;
            }
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (drawer.isEnabled()) continue;
                this.order[index++] = i;
            }
        }
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
        this.itemRepository.invalidate();
    }

    public static class DrawerData
    implements IDrawer,
    INBTSerializable<CompoundTag> {
        static Capability<IDrawerAttributes> ATTR_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerAttributes>(){});
        IDrawerAttributes attrs;
        StandardDrawerGroup group;
        @NotNull
        private ItemStack protoStack;
        private int count;
        private ItemStackMatcher matcher;

        public DrawerData(StandardDrawerGroup group) {
            this.group = group;
            this.attrs = EmptyDrawerAttributes.EMPTY;
            this.protoStack = ItemStack.f_41583_;
            this.matcher = ItemStackMatcher.EMPTY;
        }

        public void setCapabilityProvider(ICapabilityProvider capProvider) {
            this.attrs = (IDrawerAttributes)capProvider.getCapability(ATTR_CAPABILITY, null).orElse((Object)EmptyDrawerAttributes.EMPTY);
        }

        @Override
        @NotNull
        public ItemStack getStoredItemPrototype() {
            return this.protoStack;
        }

        @Override
        @NotNull
        public IDrawer setStoredItem(@NotNull ItemStack itemPrototype) {
            return this.setStoredItem(itemPrototype, true);
        }

        protected IDrawer setStoredItem(@NotNull ItemStack itemPrototype, boolean notify) {
            if (ItemStackHelper.isStackEncoded(itemPrototype)) {
                itemPrototype = ItemStackHelper.decodeItemStackPrototype(itemPrototype);
            }
            if (this.matcher.matches(itemPrototype)) {
                return this;
            }
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).m_41619_()) {
                this.reset(notify);
                return this;
            }
            this.protoStack = itemPrototype;
            this.protoStack.m_41764_(1);
            this.count = 0;
            this.matcher = new ItemStackMatcher(this.protoStack);
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
            return this;
        }

        protected IDrawer setStoredItemRaw(@NotNull ItemStack itemPrototype) {
            this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
            this.protoStack.m_41764_(1);
            this.count = 0;
            this.matcher = new ItemStackMatcher(this.protoStack);
            return this;
        }

        @Override
        public int getStoredItemCount() {
            if (this.protoStack.m_41619_()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.count;
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.setStoredItemCount(amount, true);
        }

        protected void setStoredItemCount(int amount, boolean notify) {
            if (this.protoStack.m_41619_() || this.count == amount) {
                return;
            }
            if (this.attrs.isUnlimitedVending()) {
                return;
            }
            this.count = Math.min(amount, this.getMaxCapacity());
            this.count = Math.max(this.count, 0);
            if (this.count == 0 && !this.attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset(notify);
            } else if (notify) {
                this.onAmountChanged();
            }
        }

        protected void setStoredItemCountRaw(int amount) {
            this.count = amount;
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.adjustStoredItemCount(amount, true);
        }

        protected int adjustStoredItemCount(int amount, boolean notify) {
            if (this.protoStack.m_41619_() || amount == 0) {
                return Math.abs(amount);
            }
            if (amount > 0) {
                if (this.attrs.isUnlimitedVending()) {
                    return 0;
                }
                int originalCount = this.count;
                this.count = Math.min(this.count + amount, this.getMaxCapacity());
                if (this.count != originalCount && notify) {
                    this.onAmountChanged();
                }
                if (this.attrs.isVoid()) {
                    return 0;
                }
                return amount - (this.count - originalCount);
            }
            if (this.attrs.isUnlimitedVending()) {
                return 0;
            }
            int originalCount = this.count;
            this.setStoredItemCount(originalCount + amount, notify);
            return -amount - (originalCount - this.count);
        }

        @Override
        public int getMaxCapacity(@NotNull ItemStack itemPrototype) {
            if (this.attrs.isUnlimitedStorage() || this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            if (itemPrototype.m_41619_()) {
                return 64 * this.getStackCapacity();
            }
            return itemPrototype.m_41720_().getMaxStackSize(itemPrototype) * this.getStackCapacity();
        }

        @Override
        public int getAcceptingMaxCapacity(@NotNull ItemStack itemPrototype) {
            if (this.attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            if (this.protoStack.m_41619_()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            if (this.protoStack.m_41619_()) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending() || this.attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public boolean canItemBeStored(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.protoStack.m_41619_() && !this.attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return true;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean canItemBeExtracted(@NotNull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            if (this.protoStack.m_41619_()) {
                return false;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean isEmpty() {
            return this.protoStack.m_41619_();
        }

        protected void reset(boolean notify) {
            this.protoStack = ItemStack.f_41583_;
            this.count = 0;
            this.matcher = ItemStackMatcher.EMPTY;
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.protoStack.m_41619_()) {
                return tag;
            }
            CompoundTag item = new CompoundTag();
            this.protoStack.m_41739_(item);
            tag.m_128365_("Item", (Tag)item);
            tag.m_128405_("Count", this.count);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            ItemStack tagItem = ItemStack.f_41583_;
            int tagCount = 0;
            if (nbt.m_128441_("Item")) {
                tagItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item"));
            }
            if (nbt.m_128441_("Count")) {
                tagCount = nbt.m_128451_("Count");
            }
            this.setStoredItemRaw(tagItem);
            this.setStoredItemCountRaw(tagCount);
        }

        public void syncAttributes() {
            if (!this.protoStack.m_41619_()) {
                this.matcher = new ItemStackMatcher(this.protoStack);
            }
        }

        protected int getStackCapacity() {
            return 0;
        }

        protected void onItemChanged() {
        }

        protected void onAmountChanged() {
        }
    }
}

